define(['models/abstract-model'], function(AbstractModel) {
    'use strict';

    var NO_PREFERRED_APPOINTMENTS = 'appointmentNoPreferredDatePopup';
    var NO_CLINICS = 'noClinicRadioButtons';


    return AbstractModel.extend({
        idAttribute: 'messageId',
        resourceName: 'custom-messages',

        NO_PREFERRED_APPOINTMENTS: NO_PREFERRED_APPOINTMENTS,
        NO_CLINICS: NO_CLINICS,

        url: function() {
            var resource = this.getResource();
            return resource.formatHref();
        },

        parse: function(response) {
            return response[0];
        },

        fetchMessage: function(institutionCode, messageType) {
            return AbstractModel.prototype.fetch.call(this, {
                data: {
                    'institution-code': institutionCode,
                    'type': messageType,
                },
            });
        },

        fetchClinicMessage: function(institutionCode) {
            return this.fetchMessage(institutionCode, this.NO_CLINICS);
        },

        fetchAppointmentsMessage: function(institutionCode) {
            return this.fetchMessage(institutionCode, this.NO_PREFERRED_APPOINTMENTS);
        },
    });
});
